/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8271c;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8271c.BoxInfo;
import ibm.nways.jdm8271c.NlsConstants;
import ibm.nways.jdm8271c.eui.ConfigurationAlternateGroup;
import ibm.nways.jdm8271c.eui.ConfigurationBaseGroup;
import ibm.nways.jdm8271c.eui.FaultBaseGroup;
import ibm.nways.jdm8271c.eui.P1ConfigurationBaseGroup;
import ibm.nways.jdm8271c.eui.SecurityBaseGroup;
import ibm.nways.ras.RAS;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebBrowserGroup;
import ibm.nways.web.WebContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.Point;
import java.util.ResourceBundle;

public class Jdm8271c
extends JdmBrowser {
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private GenModel deviceModel;
    private BoxInfo boxInfo;
    NlsConstants myConstants;
    private static Dimension defaultSize = new Dimension(1000, 900);
    private static final int RASID = 19;
    private static final int RASSUB = 10;
    private NavFieldOverride jdm8271cOverrides;
    static final Object[][] jdm8271cFieldOverrides = new Object[][]{{"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IfDescr.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.bridge.eui.BridgePortsPanel.sourcerouteports.visible", "false"}};
    static final Object[][] phase2Overrides = new Object[][]{{"ibm.nways.mib2.model.IpParam.Panel.IpForwarding.access", "read-only"}, {"ibm.nways.rs232.model.Rs232Port.Panel.Rs232PortInSpeed.access", "read-only"}, {"ibm.nways.rs232.model.Rs232Port.Panel.Rs232PortOutFlowType.access", "read-only"}, {"ibm.nways.rs232.model.Rs232AsyncPort.Panel.Rs232AsyncPortBits.access", "read-only"}, {"ibm.nways.rs232.model.Rs232AsyncPort.Panel.Rs232AsyncPortStopBits.access", "read-only"}, {"ibm.nways.rs232.model.Rs232AsyncPort.Panel.Rs232AsyncPortParity.access", "read-only"}};
    static final Object[][] phase2Ver1Overrides = new Object[][]{{"ibm.nways.jdm8271c.eui.SwitchStackPanel.VlanScalars.visible", "false"}};
    static final Object[][] phase1Overrides = new Object[][]{{"ibm.nways.ethernet.model.RpMau.Panel.RpMauStatus.access", "read-only"}, {"ibm.nways.ethernet.model.IfMau.Panel.IfMauStatus.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpDefaultTTL.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dStpPortEnable.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysMaxPathSplits.access", "not-supported"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysMaxHops.access", "not-supported"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysCircCount.access", "not-supported"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysDestCount.access", "not-supported"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysServCount.access", "not-supported"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVpcs.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVccs.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrType.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam1.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam2.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam3.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam4.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam5.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficQoSClass.access", "read-only"}, {"ibm.nways.sonet.model.SonetMediumSectionLine.SonetMSLInfo.SonetIfName.access", "not-supported"}, {"ibm.nways.sonet.model.SonetMediumSectionLine.SonetMSLInfo.SonetIfLkTr.access", "read-only"}, {"ibm.nways.sonet.model.SonetPath.SonetPathInfo.SonetPathIfName.access", "not-supported"}, {"ibm.nways.sonet.model.SonetPath.SonetPathInfo.SonetPathIfLkUpDnTrEn.access", "read-only"}};
    static final Object[][] model524Overrides = new Object[][]{{"ibm.nways.jdm8271c.model.P1ConfigUnit.Panel.LsConUnitFwdingMode.access", "read-only"}};
    static final Object[][] model712Overrides = new Object[][]{{"ibm.nways.jdm8271c.model.P1ConfigUnit.Panel.LsConUnitFwdingMode.access", "read-only"}, {"ibm.nways.jdm8271c.model.P1ConfigUnit.Panel.LsConUnitFwdingAction.access", "read-only"}};

    public String getModelTypeName() {
        return "ibm.nways.jdm8271c.model.Jdm8271c";
    }

    public Dimension getDefaultSize() {
        return defaultSize;
    }

    protected NavigationPoint getNavTreeRoot() {
        String string = "getNavTreeRoot";
        if (RAS.isEnabled(19, 10)) {
            RAS.enter(19, 10, (Object)this, string);
        }
        if (NlsConstants.my8271cBundle == null) {
            this.myConstants = new NlsConstants();
        }
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            if (RAS.isEnabled(19, 10)) {
                RAS.trace(19, 10, (Object)this, string, "deviceModel is NULL!");
            }
            this.rootFolder = new NavigationFolder(NlsConstants.my8271cBundle.getString("Unknown"));
            return this.rootFolder;
        }
        if (this.boxInfo != null) {
            this.boxInfo.dispose();
            this.boxInfo = null;
        }
        this.boxInfo = new BoxInfo(this.deviceModel, this);
        this.rootFolder = this.boxInfo.getDeviceStatus() == 1 ? new NavigationFolder(NlsConstants.my8271cBundle.getString("deviceName")) : new NavigationFolder(NlsConstants.my8271cBundle.getString("Unknown"));
        this.navContext = this.rootFolder.getNavContext();
        BoxInfo.setInNavContext(this.navContext, this.boxInfo);
        this.jdm8271cOverrides = new NavFieldOverride(this.navContext, jdm8271cFieldOverrides);
        if (this.boxInfo.getDevicePhase() == 2) {
            int n = 0;
            while (n < phase2Overrides.length) {
                this.jdm8271cOverrides.put(phase2Overrides[n][0], phase2Overrides[n][1]);
                ++n;
            }
            if (this.boxInfo.getDeviceVersion() == 1) {
                int n2 = 0;
                while (n2 < phase2Ver1Overrides.length) {
                    this.jdm8271cOverrides.put(phase2Ver1Overrides[n2][0], phase2Ver1Overrides[n2][1]);
                    ++n2;
                }
            }
        } else {
            int n = 0;
            while (n < phase1Overrides.length) {
                this.jdm8271cOverrides.put(phase1Overrides[n][0], phase1Overrides[n][1]);
                ++n;
            }
            switch (this.boxInfo.getDeviceType()) {
                case 5: {
                    int n3 = 0;
                    while (n3 < model524Overrides.length) {
                        this.jdm8271cOverrides.put(model524Overrides[n3][0], model524Overrides[n3][1]);
                        ++n3;
                    }
                    break;
                }
                case 8: {
                    int n4 = 0;
                    while (n4 < model712Overrides.length) {
                        this.jdm8271cOverrides.put(model712Overrides[n4][0], model712Overrides[n4][1]);
                        ++n4;
                    }
                    break;
                }
            }
        }
        return this.rootFolder;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        String string = "getDeviceGraphicPanel";
        GraphicPanel graphicPanel = null;
        if (RAS.isEnabled(19, 10)) {
            RAS.enter(19, 10, (Object)this, string);
        }
        long l = System.currentTimeMillis();
        if (this.deviceModel != null) {
            graphicPanel = this.boxInfo.getDeviceGraphic();
        } else {
            GraphicContainer graphicContainer = new GraphicContainer();
            Label label = new Label(NlsConstants.my8271cBundle.getString("NoGraphic"), 1);
            label.setFont(new Font("Serif", 1, 14));
            label.setLocation(new Point(35, -5));
            graphicContainer.add(label);
            graphicPanel = new GraphicPanel((GraphicHandler)this, (Component)graphicContainer);
        }
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 10)) {
            RAS.trace(19, 10, (Object)this, string, "Finished graphic in " + String.valueOf(l2 - l) + " msecs");
        }
        return graphicPanel;
    }

    protected void getRestOfNavTree() {
        String string = "getRestOfNavTree";
        this.displayMsg(NlsConstants.my8271cBundle.getString("StartNavTree"));
        this.tree = this.getNavigationBrowser();
        this.navContext.put((Object)"TREE", (Object)this.tree);
        if (this.deviceModel != null && (this.boxInfo.getDeviceStatus() == 1 || this.boxInfo.getDeviceStatus() == 3)) {
            if (this.boxInfo.getDevicePhase() == 1) {
                this.buildP1ConfigurationFolder(this.rootFolder);
            } else {
                this.buildConfigurationFolder(this.rootFolder);
            }
            this.buildFaultFolder(this.rootFolder);
            this.buildSecurityFolder(this.rootFolder);
            this.buildToolsFolder(this.rootFolder);
            if (RAS.isEnabled(19, 10)) {
                RAS.trace(19, 10, (Object)this, string, "Built full nav tree.");
            }
        } else {
            this.buildAltConfigurationFolder(this.rootFolder);
            this.buildToolsFolder(this.rootFolder);
            if (RAS.isEnabled(19, 10)) {
                RAS.trace(19, 10, (Object)this, string, "Built partial nav tree.");
            }
        }
        this.displayMsg(NlsConstants.my8271cBundle.getString("EndNavTree"));
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder) {
        String string = "buildConfigurationFolder";
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Configuration");
            ConfigurationBaseGroup configurationBaseGroup = new ConfigurationBaseGroup((JdmBrowser)this, genModel);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationBaseGroup);
            configurationBaseGroup.setIsInitiallyExpanded(false);
            navigationFolder.add((NavigationPoint)configurationBaseGroup);
            return;
        }
        catch (Exception exception) {
            RAS.logError(19, 10, (Object)this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Configuration", (Object)"deviceModel");
            RAS.logException(19, 10, (Object)this, string, exception);
            this.buildAltConfigurationFolder(navigationFolder);
            return;
        }
    }

    private void buildP1ConfigurationFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildP1ConfigurationFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("P1Configuration");
            P1ConfigurationBaseGroup p1ConfigurationBaseGroup = new P1ConfigurationBaseGroup((JdmBrowser)this, genModel);
            this.tree.addEventListener((NavigationBrowserEventListener)p1ConfigurationBaseGroup);
            p1ConfigurationBaseGroup.setIsInitiallyExpanded(false);
            navigationFolder.add((NavigationPoint)p1ConfigurationBaseGroup);
            return;
        }
        catch (Exception exception) {
            RAS.logError(19, 10, (Object)this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"P1Configuration", (Object)"deviceModel");
            RAS.logException(19, 10, (Object)this, string, exception);
            this.buildAltConfigurationFolder(navigationFolder);
            return;
        }
    }

    private void buildAltConfigurationFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildAltConfigurationFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigALT");
        }
        catch (Exception exception) {
            RAS.logError(19, 10, (Object)this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"ConfigALT", (Object)"deviceModel");
            RAS.logException(19, 10, (Object)this, string, exception);
            genModel = this.deviceModel;
        }
        if (genModel == null) {
            genModel = this.deviceModel;
        }
        ConfigurationAlternateGroup configurationAlternateGroup = new ConfigurationAlternateGroup((JdmBrowser)this, genModel);
        this.tree.addEventListener((NavigationBrowserEventListener)configurationAlternateGroup);
        configurationAlternateGroup.setIsInitiallyExpanded(false);
        navigationFolder.add((NavigationPoint)configurationAlternateGroup);
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildFaultFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Fault");
        }
        catch (Exception exception) {
            RAS.logError(19, 10, (Object)this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Fault", (Object)"deviceModel");
            RAS.logException(19, 10, (Object)this, string, exception);
        }
        if (genModel != null) {
            FaultBaseGroup faultBaseGroup = new FaultBaseGroup((JdmBrowser)this, genModel);
            faultBaseGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultBaseGroup);
            navigationFolder.add((NavigationPoint)faultBaseGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(NlsConstants.my8271cBundle.getString("Fault"), (NavigationDestination)new MessageDestination(NlsConstants.my8271cBundle.getString("NotConfigured"))));
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildSecurityFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Security");
        }
        catch (Exception exception) {
            RAS.logError(19, 10, (Object)this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Security", (Object)"deviceModel");
            RAS.logException(19, 10, (Object)this, string, exception);
        }
        if (genModel != null) {
            SecurityBaseGroup securityBaseGroup = new SecurityBaseGroup((JdmBrowser)this, genModel);
            securityBaseGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)securityBaseGroup);
            navigationFolder.add((NavigationPoint)securityBaseGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(NlsConstants.my8271cBundle.getString("Security"), (NavigationDestination)new MessageDestination(NlsConstants.my8271cBundle.getString("NotConfigured"))));
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = null;
        String string = "buildToolsFolder";
        navigationFolder2 = new NavigationFolder(NlsConstants.my8271cBundle.getString("ToolsGroupTitle"));
        navigationFolder2.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder2.setIsInitiallyExpanded(true);
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            WebBrowserGroup webBrowserGroup;
            WebContext webContext;
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string2 = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string2);
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            Browser browser = new Browser(NlsConstants.my8271cBundle.getString("MibBrowserTitle"), (JdmBrowser)this, snmpContextModel);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            if (this.getIsApplication()) {
                webContext = new AnalyzerJdmContext(string2, this.getServerPortNumber());
                webBrowserGroup = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = webBrowserGroup.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)webContext);
                navigationFolder2.add((NavigationPoint)webBrowserGroup);
            }
            webContext = new WebContext(string2);
            if (this.boxInfo.getDevicePhase() == 1) {
                webContext.only_nhd_url();
            } else {
                webContext.support_and_device();
            }
            webBrowserGroup = new WebBrowserGroup(webContext);
            webBrowserGroup.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            webBrowserGroup.setIsInitiallyExpanded(false);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)webBrowserGroup);
            navigationFolder2.add((NavigationPoint)webBrowserGroup);
            return;
        }
        catch (Exception exception) {
            RAS.logError(19, 10, (Object)this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"_ContextInfo", (Object)"deviceModel");
            RAS.logException(19, 10, (Object)this, string, exception);
            if (RAS.isEnabled(19, 10)) {
                RAS.trace(19, 10, (Object)this, string, "Can't build telnet & MibBrowser folders ");
            }
            return;
        }
    }
}

